function [xx,yy] = nlfd(x, y, fcat)
%.
% Funcion nlfd
% [x,y] = nlfd(xa, xb, ya, yb, n, C)
%
% Resuelve un problema de diferencias finitas no lineal (en realidad solo 
% resuelve el problema de la catenaria). Para ello, 
% utiliza un metodo de Newton sobre las ecuaciones no lineales 
% resultantes.
%
% ENTRADA
%
%    x      valore de la variable independiente 
%    y      estimacion inicial de la solucion
%    fcat   funcion que proporciona el sistema de ecuaciones que
%           corresponde al problema de diferencias finitas
%
% SALIDA
%
%        x valores de la variable independiente en los que se proporciona
%          solucion
%        y valores de la solucion
%

yy0 = y(2:end-1);

options=optimset('Display','iter');
yy = fsolve( fcat, yy0, options);

yy = [y(1) yy y(end)];
xx = x;
